/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.nodes.IFormatterNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public abstract class FormatterContext
implements IFormatterContext,
Cloneable {
    private int indent;
    private boolean indenting = true;
    private boolean comment = false;
    private boolean wrapping = false;
    private int blankLines = 0;
    private final List<PathEntry> path = new ArrayList<PathEntry>();

    public FormatterContext(int indent) {
        this.indent = indent;
    }

    public IFormatterContext copy() {
        try {
            return (IFormatterContext)this.clone();
        }
        catch (CloneNotSupportedException e) {
            IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)"FormatterContext.copy() error", (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            throw new IllegalStateException();
        }
    }

    public void decIndent() {
        --this.indent;
    }

    public void incIndent() {
        ++this.indent;
    }

    public void resetIndent() {
        this.indent = 0;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    public void setIndenting(boolean value) {
        this.indenting = value;
    }

    public boolean isComment() {
        return this.comment;
    }

    public void setComment(boolean value) {
        this.comment = value;
    }

    public int getBlankLines() {
        return this.blankLines;
    }

    public void resetBlankLines() {
        this.blankLines = -1;
    }

    public void setBlankLines(int value) {
        if (value >= 0 && value > this.blankLines) {
            this.blankLines = value;
        }
    }

    public void enter(IFormatterNode node) {
        this.path.add(new PathEntry(node));
    }

    public void leave(IFormatterNode node) {
        PathEntry entry = this.path.remove(this.path.size() - 1);
        if (entry.node != node) {
            throw new IllegalStateException("leave() - node mismatch");
        }
        if (!this.path.isEmpty() && this.isCountable(node)) {
            PathEntry parent = this.path.get(this.path.size() - 1);
            ++parent.childIndex;
        }
    }

    protected boolean isCountable(IFormatterNode node) {
        return true;
    }

    public IFormatterNode getParent() {
        if (this.path.size() > 1) {
            PathEntry entry = this.path.get(this.path.size() - 2);
            return entry.node;
        }
        return null;
    }

    public int getChildIndex() {
        if (this.path.size() > 1) {
            PathEntry entry = this.path.get(this.path.size() - 2);
            return entry.childIndex;
        }
        return -1;
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean value) {
        this.wrapping = value;
    }

    private static class PathEntry {
        final IFormatterNode node;
        int childIndex = 0;

        public PathEntry(IFormatterNode node) {
            this.node = node;
        }
    }
}

